<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN" CDATA DSSSL>
<!ENTITY by              " "> <!-- overridden by peter for copyright -->
]>

<style-sheet>
<style-specification use="docbook">
<style-specification-body>

;; $Id$
;; Driver file for the DocBook stylesheets.
;; Defines a presentation-like behaviour

;; see above - "av" needs killing 
(define %gentext-no-by% "&by;") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe 

; the footer would just be a visual distraction
(define %footer-navigation% #f)

; we don't need labels
(define %chapter-autolabel% #f)

; this stylesheet name will be hardcoded in all HTML files
(define %stylesheet% "dbslide.css")

; we use a cascading stylesheet
(define %stylesheet-type% "text/css")

(define %generate-legalnotice-link% #t)
;;(define $legalnotice-link-file$ legalnotice)
;;(define ($legalnotice-link-file$ legalnotice)
;;  ;; Name of output file for legal notices
;;  (string-append "ln" 
;;         (number->string (all-element-number legalnotice))
;;         %html-ext%))
(define ($legalnotice-link-file$ legalnotice)
  ;; Name of output file for legal notices
  (string-append "legalnotice" 
;;         (number->string (all-element-number legalnotice))
         %html-ext%))

(define %use-id-as-filename%
  ;; Use ID attributes as name for component HTML files?
  #t)

(define %root-filename%
  ;; Name for the root HTML document
  "index")

(define %html-ext% 
  ;; Default extension for HTML output files
  ".html")

;; peters stuff ends


; This way we can abuse simplesects as simple headers without triggering a new chunk or a section TOC. I'm afraid this is a slimy hack, I hope it doesn't break anything else. 
(define (section-element-list)
  (list (normalize "sect1")
	(normalize "sect2")
	(normalize "sect3") 
	(normalize "sect4")
	(normalize "sect5")
	(normalize "section")
;	(normalize "simplesect")
	(normalize "refsect1") 
	(normalize "refsect2") 
	(normalize "refsect3")))

; insert the JavaScript keyboard navigation code into the HTML header
(define ($standard-html-header$ #!optional
				(prev  (prev-chunk-element))
				(next  (next-chunk-element))
				(prevm (prev-major-component-chunk-element))
				(nextm (next-major-component-chunk-element)))
  ;; A hook function to add additional tags to the HEAD of your HTML files
  (let* ((info (info-element))
	 (kws  (select-elements (descendants info) (normalize "keyword")))
	 (home (nav-home (current-node)))
	 (up   (parent (current-node))))
    (make sequence
      ;; Add the META NAME=GENERATOR tag
      (make empty-element gi: "META"
	    attributes: (list (list "NAME" "GENERATOR")
			      (list "CONTENT" 
				    (string-append (stylesheet-version) " and dbslide HTML stylesheet Version 0.1"))))

      ;; Add the LINK REV=MADE tag
      (if %link-mailto-url%
	  (make empty-element gi: "LINK"
		attributes: (list (list "REV" "MADE")
				  (list "HREF" %link-mailto-url%)))
	  (empty-sosofo))

      ;; Add the LINK REL=HOME tag
      (if (nav-home? (current-node))
	  (make empty-element gi: "LINK"
		attributes: (append '(("REL" "HOME"))
				    (if (equal? (element-title-string home) 
						"")
					'()
					(list 
					 (list "TITLE"
					       (element-title-string home))))
				    (list (list "HREF" (href-to home)))))
	  (empty-sosofo))

      ;; Add the LINK REL=UP tag
      (if (nav-up? (current-node))
	  (if (or (node-list-empty? up)
		  (node-list=? up (sgml-root-element)))
	      (empty-sosofo)
	      (make empty-element gi: "LINK"
		    attributes: (append  '(("REL" "UP"))
					 (if (equal? (element-title-string up)
						     "")
					     '()
					     (list
					      (list "TITLE" 
						    (element-title-string up))))
					 (list (list "HREF" (href-to up))))))
	  (empty-sosofo))

      ;; Add the LINK REL=PREVIOUS tag
      (if (node-list-empty? prev)
	  (empty-sosofo)
	  (make empty-element gi: "LINK"
		attributes: (append '(("REL" "PREVIOUS"))
				    (if (equal? (element-title-string prev) "")
					'()
					(list
					 (list "TITLE"
					       (element-title-string prev))))
				    (list (list "HREF" (href-to prev))))))

      ;; Add the LINK REL=NEXT tag
      (if (node-list-empty? next)
	  (empty-sosofo)
	  (make empty-element gi: "LINK"
		attributes: (append '(("REL" "NEXT"))
				    (if (equal? (element-title-string next) "")
					'()
					(list
					 (list "TITLE"
					       (element-title-string next))))
				    (list (list "HREF" (href-to next))))))

      ;; Add META NAME=KEYWORD tags
      (let loop ((nl kws))
	(if (node-list-empty? nl)
	    (empty-sosofo)
	    (make sequence
	      (make empty-element gi: "META"
		    attributes: (list (list "NAME" "KEYWORD")
				      (list "CONTENT" (data (node-list-first nl)))))
	      (loop (node-list-rest nl)))))

      ;; Add LINK REL=STYLESHEET tag
      (if %stylesheet%
	  (make empty-element gi: "LINK"
		attributes: (list (list "REL" "STYLESHEET")
				  (list "TYPE" %stylesheet-type%)
				  (list "HREF" %stylesheet%)))
	  (empty-sosofo))

      ;; Add the Javasript keyboard and mouse navigation code for Netscape
      (make element gi:"SCRIPT"
	    attributes: (list
			 (list "LANGUAGE" "JavaScript1.2")
			 (list "TYPE" "text/JavaScript"))
	    (make sequence
	      (literal (string-append 
  "var Netscape = new Boolean();
  if(navigator.appName == 'Netscape')  Netscape = true;  

  function keypress(event)
  {
   if(Netscape)
    { 
      switch(event.which)
      {
      case 13:
      case 32:
      case 110:"
  (if (node-list-empty? next)
      ""
      (string-append
      "window.location.href='"
	      (href-to next)
	      "';"))
      "break;
      case 8:
      case 98:
      case 112:"
  (if (node-list-empty? prev)
      ""
      (string-append
      "window.location.href='"
	      (href-to prev)
	      "';"))
      "break;
      case 104:"
  (if (node-list-empty? home)
      ""
      (string-append
      "window.location.href='"
	      (href-to home)
	      "';"))
      "break;
      }  
      return true;
    }
  }
  function mousepress(event)  
  {
   if(Netscape)
   {
     if (event.modifiers & Event.ALT_MASK)
     {" 
  (if (node-list-empty? home)
      ""
      (string-append
      "window.location.href='"
	      (href-to home)
	      "';"))
    "}
     else if (event.pageX < 200)
     {"
  (if (node-list-empty? prev)
      ""
      (string-append
      "window.location.href='"
	      (href-to prev)
	      "';"))
    "}
     else
     {"
  (if (node-list-empty? next)
      ""
      (string-append
      "window.location.href='"
	      (href-to next)
	      "';"))
    "}
     return true;
   }
  }
  document.onkeydown = keypress;
  document.onmouseup = mousepress;"))))

      ;; Add the JSript keyboard and mouse navigation code for MSIE
      (make element gi:"SCRIPT"
	    attributes: (list
			 (list "FOR" "document")
			 (list "EVENT" "onkeydown()")
			 (list "LANGUAGE" "JScript")
			 (list "TYPE" "text/JScript"))
	    (make sequence
	      (literal (string-append 
  "{ 
      switch(window.event.keyCode)
      {
      case 13:
      case 70:
      case 78:"
  (if (node-list-empty? next)
      ""
      (string-append
      "window.location.href='"
	      (href-to next)
	      "';"))
      "break;
      case 66:
      case 80:"
  (if (node-list-empty? prev)
      ""
      (string-append
      "window.location.href='"
	      (href-to prev)
	      "';"))
      "break;
      case 72:"
  (if (node-list-empty? home)
      ""
      (string-append
      "window.location.href='"
	      (href-to home)
	      "';"))
      "break;
      }  
      return true;}"))))

      (make element gi:"SCRIPT"
	    attributes: (list
			 (list "FOR" "document")
			 (list "EVENT" "onmouseup()")
			 (list "LANGUAGE" "JScript")
			 (list "TYPE" "text/JScript"))
	    (make sequence
	      (literal (string-append 
  "{
     if (window.event.altKey)
     {"     
  (if (node-list-empty? home)
      ""
      (string-append
      "window.location.href='"
	      (href-to home)
	      "';"))
    "}
     else
     {
       if (window.event.clientX < 200) 
       {"
  (if (node-list-empty? prev)
      ""
      (string-append
      "window.location.href='"
	      (href-to prev)
	      "';"))
      "}
       else
       {"
  (if (node-list-empty? next)
      ""
      (string-append
      "window.location.href='"
	      (href-to next)
	      "';"))
      "}
     }
     return true;}"))))

      ($user-html-header$ home up prev next))))

; the default graphics format for HTML
(define %graphic-default-extension% "gif")

; make sure we have a "HTML.manifest" for fixdbslide
(define html-manifest #t)
(define html-manifest-filename "HTML.manifest")


</style-specification-body>
</style-specification>

<external-specification id="docbook" document="docbook.dsl">

</style-sheet>
