<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN" CDATA DSSSL>
]>

<style-sheet>
<style-specification use="docbook">
<style-specification-body>

;; $Id$
;; Driver file for the DocBook stylesheets.
;; Defines a overhead-like behaviour

; the overheads should resemble the screen presentation
(define %paper-type% "USlandscape")

; use large fonts
(define %bf-size% 18pt)

(define-unit em %bf-size%)

; relative font sizes
(define %hsize-bump-factor% 1.1)

; redefine page margins
(define %top-margin% 3pi)

(define %bottom-margin% 3pi)

(define %header-margin% 0.5pi)

(define %footer-margin% 0.5pi)

(define %left-margin% 4pi)

(define %right-margin% 4pi)

; don't need a list of tables
(define ($generate-book-lot-list$)
  (list))

;(define %generate-part-toc-on-titlepage% #f)

; no labels on chapters
(define %chapter-autolabel% #f)

; no running heads
(define %chap-app-running-heads% #f)

; don't use footer
(define (page-outer-footer gi)
  (empty-sosofo))

(define (first-page-outer-footer gi)
  (empty-sosofo))

; use eps as default image extension
(define %graphic-default-extension% "eps")

; redefine spacing
(define %line-spacing-factor% 1.2)

(define %head-before-factor% 0.5)

(define %head-after-factor% 0.25)

(define %para-sep% 
  (/ %bf-size% 1.5))

(define %block-sep% 
  (* %para-sep% 1.2))

; this increases space between itemizedlist and the next header (bad) but it also increases the too small space between itemizedlist and the next para (good)
(define ($list$)
  (make display-group
    start-indent: (if (INBLOCK?)
                      (inherited-start-indent)
                      (+ %block-start-indent% (inherited-start-indent)))
    space-after:  2pi))

; set our favourite fonts. These settings may be platform-dependent.
(define %title-font-family% "Arial")

(define %body-font-family% "Times New Roman")

(define %mono-font-family% "Courier New")

(define %admon-font-family% "Arial")

(define %guilabel-font-family% "Arial")

; eliminate the (whatever-it-is-really-called) second titlepage
(define (book-titlepage-verso-elements)
  (list))

; show only the slide (=top level) headings in the toc
(define (toc-depth nd) 1)

; Print the TOC entry for tocentry without page numbers 
(define ($toc-entry$ tocentry level)
  (make paragraph
    start-indent: (+ %body-start-indent%
		     (* %toc-indent% level))
    first-line-start-indent: (* -1 %toc-indent%)
    font-weight: (if (= level 1) 'bold 'medium)
    space-before: (if (= level 1) (* %toc-spacing-factor% 6pt) 0pt)
    space-after: (if (= level 1) (* %toc-spacing-factor% 6pt) 0pt)
    quadding: 'start
; use only one of the following two blocks:
;; begin block 1
; use the following line to get a TOC w/o links
;    (element-title-sosofo tocentry)))
;; end block 1
;; begin block 2
; use this block to get a TOC with links
    (make link
      destination: (node-list-address tocentry)
      (make sequence
	(if (equal? (element-label tocentry) "")
	    (empty-sosofo)
	    (make sequence
	      (element-label-sosofo tocentry)
	      (literal (gentext-label-title-sep (gi tocentry)))))
	(element-title-sosofo tocentry)))))
;; end block 2


</style-specification-body>
</style-specification>

<external-specification id="docbook" document="docbook.dsl">

</style-sheet>

